package org.example;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class IntArrayToHashSet {
    public static void main(String[] args) {
        int[] intArray = {1, 2, 3, 4, 5, 2, 3};

        HashSet<Integer> intHashSet = new HashSet<>();

        for (int num : intArray) {
            intHashSet.add(num);
        }

        // Printing the unique elements in the HashSet
        System.out.println("Unique elements in the HashSet: " + intHashSet);

        HashSet<Integer> set = Arrays.stream(intArray)
                .distinct()
                .boxed()
                .collect(Collectors.toCollection(HashSet::new));

        System.out.println(set); // Output: [1, 2, 3, 4, 5]

        HashSet<Integer> set1 = new HashSet<>(Arrays.asList(ArrayUtils.toObject(intArray)));

        System.out.println(set1); // Output: [1, 2, 3, 4, 5]

        HashSet<Integer> set2 = Sets.newHashSet(Arrays.asList(ArrayUtils.toObject(intArray)));
        System.out.println(set2); // Output: [1, 2, 3, 4, 5]
    }
}